-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    
    self.reinfTargetReach:LinkToTarget("victory")
    self.armyDestroyed:LinkToTarget("defeat")
    
    if not self.loaded then
      self.active = false
      self.timer = 4
    end
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      reinfUnits = self.p0:UnitsInRadiusNumber(self:GetPosition(), 2000, '*')
      allUnits = self.p0:CheckUnitsCount(25, 0)
          
      if reinfUnits >= 25 then
        self.reinfTargetReach:TriggerAllTargets()
        self.active = false
      elseif allUnits < 25 then
        self.armyDestroyed:TriggerAllTargets()
        self.active = false
      end
    end
  end
end

function OnTrigger(self, source, target)
  if target == "reinfTargetActive" then
    self.active = true
    self.p0:WinQuest('D8G_GOAL_1')
    self.p0:AddQuest('D8G_GOAL_2','main')
    self.p0:SetQuestPosition('D8G_GOAL_2', self:GetPosition().x, self:GetPosition().y)
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.timer)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("reinfTargetActive")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("reinfTargetReach")
  self:AddTriggerSource("armyDestroyed")
end
